******************************************
MACRO for CPS Survey Years 1964-67 
to calculate State Tax Liabilities using
IncTaxCalc SAS Program


4/29/10:  EDITED TO RUN ON JIM'S COMPUTER,
		  THIS PRGM CREATES
		  TAXS* SAS DATASETS IN THE TAXSIM LIBRARY THAT
		  INCLUDES BOTH STATE AND FEDERAL TAX INFO. 

******************************************;
filename tax64 'D:\Jim\Data\raw_taxsim\cps\taxsim1964out.txt';
filename tax65 'D:\Jim\Data\raw_taxsim\cps\taxsim1965out.txt';
filename tax66 'D:\Jim\Data\raw_taxsim\cps\taxsim1966out.txt';
filename tax67 'D:\Jim\Data\raw_taxsim\cps\taxsim1967out.txt';

**********************************************************************
Before beginning this program make sure the following 
files are placed in your taxsim library location: 

1) IncTaxCalc.SAS (SAS program for Calculating State Tax Liabilities
2) IncTaxState.dat (data file that goes along with SAS Program)
3) IncTaxfed.dat (data file that goes along with SAS Program)

It should be noted that only 1 change needs to be made to 
the IncTaxCalc.SAS program.  It involves the SAS log and having it 
be written to another file.  To avoid this problem I have commented 
out the command that would have the log written to another file: 
(Lines 155-156 right before III Pathnames Section);
/*
PROC PRINTTO LOG=" &outputpath.\IncTaxCalc.log " NEW;
RUN;
*/
*I had problems with the program before I made the above change
after that it runs fine
**********************************************************************;
%macro taxfed6467(yr);
***********************************
INC Tax Calculator Program
***********************************;
data inc&yr;
set cpsdata.taxsim&yr;
fedyear=ref_year;
stateyear=ref_year;
kids1=0;
income=0;
div2=0;
int2=0;
pension2=0;
ui2=0;
age=0;
agesp=0;
blind=0;
businc1=0;
businc2=0;
farminc1=0;
farminc2=0;
ltcg1=0;
ltcg2=0;
othcg1=0;
othcg2=0;
teint1=0;
teint2=0;
rentinc1=0;
rentinc2=0;
ssben2=0;
partscorp1=0;
partscorp2=0;
othinc1=0;
othinc2=0;
othadj1=0;
othadj2=0;
charity=0;
charcg=0;
intpaid=0;
invint=0;
stinctax=0;
proptax=0;
salestax=0;
taxnodetail=0;
medexp=0;
casualty=0;
movex=0;
busex=0;
miscdedlim=0;
omiscded=0;
childcare=0;
fdcred=0;
otaxpref=0;
oamtadj=0;
avglaginc=0;
psincome=0;
psded=0;
rentpay=0;
homeval=0;
run;

data final&yr;
set inc&yr;
if filestat=1 then filetype='s';
else if filestat=2 then filetype='m';
else if filestat=3 then filetype='h';
drop fill filestat state ;
run;


data final&yr;
set final&yr;
* RENAME VARIABLES SO THEY WORK WITH THE INCTAXCALC PROGRAM;
rename ref_year=year; 
rename filetype=filertype;
rename totdep=deps;
rename kid_eitc=kids2;
rename kid_fcc=kids3;
rename num_gt65=agenum;
rename taxinc=wagsal1;
rename tfu_wifi=wagsal2;
rename inc9=div1;
rename inc10=int1;
rename inc11=pension1;
rename inc18=ui1;
rename inc12=ssben1;
rename ts_state=state;
run;
%mend taxfed6467;
%taxfed6467(1964);
%taxfed6467(1965);
%taxfed6467(1966);
%taxfed6467(1967);

*Create 1 dataset to run through IncTaxCalc;
data statetax;
set final1964 final1965 final1966 final1967;
run;



filename macs "D:\My SAS Libraries\CPS\taxsim_output" ;
options mautosource ;
options sasautos=macs ;

* I CHANGED THIS PART FOR MY COMPUTER;
* READ IN THE INCTAXCALC PROGRAM;
%include 'D:\My SAS Libraries\CPS\taxsim_output\IncTaxCalc.sas';
%IncTaxCalc(
programpath=D:\My SAS Libraries\CPS\taxsim_output,
inputpath=D:\My SAS Libraries\CPS\taxsim_output,
outputpath=D:\My SAS Libraries\CPS\taxsim_output,
inputset=statetax,
outputset=upout,
fedparam=IncTaxFed,
stateparam=IncTaxState,
loadparam=1,
mtrvar=ltcg1,
incrementkind=dollar,
incrementquantity=0.1, 
detail=0,
inputformat=2,
outputformat=1,
reverseMTR=1,
checkMTR=0.9,
statecodetype=1,
yearstart=63,
cbinclude=1,
local=1 ) ;
run;
proc means data=taxsim.upout;
run;

%macro taxfed6467a(yr,dir);
*Create different datasets for different years;

data Inc&yr;
set taxsim.upout;
if year=&yr-1;
keep id taxs;
run;


data taxsim.taxsimout&yr;
infile &dir;
input CaseID Year State FTL STL FICA EFMR ESMR FICArate;
run;
proc means data=taxsim.taxsimout&yr;
run;

data taxsim&yr;
set taxsim.taxsimout&yr;
rename CaseID=id;
run;

data taxsim&yr;
set taxsim&yr;
keep id year FTL FICA;
run;

proc sort data=inc&yr;
by id;
run;
proc sort data=taxsim&yr;
by id;
run;

data meg&yr;
merge taxsim&yr inc&yr;
by id;
run;

proc means data=meg&yr;
run;

data taxsim.taxs&yr;
set meg&yr;
run;

%mend taxfed6467a;
%taxfed6467a(1964,tax64);
%taxfed6467a(1965,tax65);
%taxfed6467a(1966,tax66);
%taxfed6467a(1967,tax67);

